/**
 * function will be called when the framework has been loaded.
 */



var scene;
var layers;
var map;
var framework = vcs.vcm.Framework.getInstance();

if (framework.isInitialized()){
  onMAPLoaded();
} else {
  framework.subscribe("FRAMEWORK_INITIALIZED", onMAPLoaded);
};

function open_type_dlg()
{
 $('#typedlg').dialog({
        height: 300,
        width: 800,
        autoOpen: false,
        modal: false,
        dialogClass : 'chat',
        resizable: true
, position: {
    my: "left center",
    at: "left center",
    of: window,
    collision: "none"
}
, create: function (event, ui) {
    $(event.target).parent().css('position', 'fixed');
}
    });

  $('#typedlg').dialog("open");
};

function type(){

  var span = document.createElement('span');
  //span.setAttribute('type',"button");
  span.setAttribute('class', "navbutton vcm-btn-base-trans vcm-btn-font-default vcm-btn-font-default-hover vcm-no-select vcm-btn-base-dye01-hover");
  span.setAttribute('style', "padding:0.5rem; border-radius:2px;");
  span.setAttribute('onclick',"open_type_dlg()");

  var div = document.getElementsByClassName("desktopMenuButtons")[0];
  div.appendChild(span).innerHTML="<img src='http://119.75.24.66:8003/Scene/layer_management.png' title='Layer management' class=\"layer-logo header-btn-text\" style=\"margin-top:2px;\">Layer Management";
  
  var span = document.createElement('a');
  span.setAttribute('type',"button");
  
  
  var tool = document.getElementsByClassName("tool-box")[0];
  tool.setAttribute('style', "float:left;");
  
};

function open_flood_dlg()
{
 $('#flooddlg').dialog({
        height: 530,
        width: 950,
        autoOpen: false,
        modal: false,
        dialogClass : 'chat',
        resizable: false
, position: {
    my: "left center",
    at: "left center",
    of: window,
    collision: "none"
}
, create: function (event, ui) {
    $(event.target).parent().css('position', 'fixed');
}

    });

  $('#flooddlg').dialog("open");
};

function flood(){


  
  var span = document.createElement('a');
  span.setAttribute('type',"button");
  span.setAttribute('onclick',"open_flood_dlg()");
  
  


  var div = document.getElementById("widget-box");
  div.appendChild(span).innerHTML="<img src='http://119.75.24.66:8003/Scene/flood.png' title='Flood modelling' width='40' height='40'>";


};

function screenshot(){

  var span = document.createElement('b');
  span.setAttribute('type',"button");
  span.setAttribute('onclick',"pdf_export()");
  
  


  var div = document.getElementById("widget-box");
  div.appendChild(span).innerHTML="<img src='http://119.75.24.67:8004/tcp/screenshot.png' id='screenshot' title='Screenshot' width='40' height='40'>";
  
  


};

  
  
function change3(){

var color4 = document.getElementById("colorChoice3").value;
var layer4 = framework.getLayerByName('Buildings');
            
var st3 = new vcs.vcm.util.style.DeclarativeStyleItem( {
     
  "name": "ss1",
  "declarativeStyle":{
  "show": "true",
  "color": "color"+"('"+String(color4)+"')"
  
  }
});  

framework.addStyle(st3);

layer4.setStyle("ss1");
//layer.setStyle(s);                                                                      
                                                                        


};

function change1(){
var color4 = document.getElementById("colorChoice3").value;
var layer2 = framework.getLayerByName('Buildings');


  
var s1 = new vcs.vcm.util.style.DeclarativeStyleItem( {
     
  "name": "s2",
  "declarativeStyle":{
  "show": {
          "conditions": [
            [
              "${attributes.measuredHeight} === undefined",
              "false"
            ],
            [
              "${attributes.measuredHeight} > " + String(document.getElementById("height_filter").value),
              "true"
            ],

            [
              "true",
              "false"
            
            ]
       
          ]
        },
  "color": "color"+"('"+String(color4)+"')"
  
  }
});
  
framework.addStyle(s1);

layer2.setStyle("s2");
//layer.setStyle(s);                                                                      
                                                                        
var span = document.getElementById('download').children[0];
span.setAttribute('href',`http://tcp.imagetrekk.com:8080/geoserver/tcp/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=tcpo:tcpo_building_14_oct&cql_filter=height>'`+String(document.getElementById("height_filter").value)+`'&maxFeatures=10000&outputFormat=shape-zip`);
span.setAttribute('type', "button");


}

function change2(){
var color2 = document.getElementById("colorChoice1").value;
var layer2 = framework.getLayerByName('Buildings');


  
var s1 = new vcs.vcm.util.style.DeclarativeStyleItem( {
     
  "name": "s2",
  "declarativeStyle":{
  "show": {
          "conditions": [
            [
              "${attributes.measuredHeight} === undefined",
              "false"
            ],
            [
              "${attributes.measuredHeight} > " + String(document.getElementById("height_filter").value),
              "true"
            ],

            [
              "true",
              "false"
            
            ]
       
          ]
        },
  "color": "color"+"('"+String(color2)+"')"
  
  }
});
  
framework.addStyle(s1);

layer2.setStyle("s2");
//layer.setStyle(s);            


}

function delay(){

  
  var span = document.createElement('a');
  span.innerHTML='<input type="color" id="colorChoice" zoom:50%" onchange="change()">';


  var div = document.getElementsByClassName("desktopMenuButtons")[0];
  div.appendChild(span);
  
}

function delay1(){

  var span = document.createElement('a');
  span.setAttribute('href'," http://119.75.24.66:8003/Apps/cesium_flood_Haryana/flood/flood.html");
  
  span.setAttribute('target',"_blank");
  var div = document.getElementsByClassName("desktopMenuButtons")[0];
  div.appendChild(span).innerHTML="<img src='http://119.75.24.66:8003/Scene/flood.png' width='60' height='40'>"; 

}


function delay2(){  
  var span = document.createElement('a');
  
 
  var div = document.getElementById('download');
  div.appendChild(span).innerHTML="<img src='http://119.75.24.66:8003/Scene/download.png' alt='download' width='60' height='25'>"; 
  
  var span = document.createElement('a');
  
 
  var div = document.getElementById('download1');
  div.appendChild(span).innerHTML="<img src='http://119.75.24.66:8003/Scene/download.png' alt='download' width='60' height='25'>"; 

}








function polygonfilter()
{


var utm = "+proj=utm +zone=43 +ellps=WGS84 +datum=WGS84 +units=m +no_defs";
var wgs84 = "+proj=longlat +datum=WGS84 +no_defs";




  
map.getCesiumWidget().screenSpaceEventHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);
  var colormatarial=Cesium.Color.WHITE.withAlpha(0.3)
  var point;
    function createPoint(worldPosition) {
      
       point =  map.getEntities().add({
        
        position : worldPosition,
        point : {
            color : colormatarial,
            pixelSize : 2,
            heightReference: Cesium.HeightReference.CLAMP_TO_GROUND
        }
    });
   
      
      
}
var drawingMode = 'polygon';
function drawShape(positionData) {
    var shape;
    
    
  
    
      
       shape = map.getEntities().add({
    
    name : 'uniqueId',
            polygon: {
                hierarchy: positionData,
                material: colormatarial,
                outline : true,
                outlineColor : Cesium.Color.BLACK
            }
});
    var ellipsoid = scene.globe.ellipsoid;
    
    var text = "";
    var text1 = "";
    var i;
    for (i=0; i<positionData.length; i++){
    var cartographic = ellipsoid.cartesianToCartographic(positionData[i]);
    var longitudeString = Cesium.Math.toDegrees(cartographic.longitude);
    var latitudeString = Cesium.Math.toDegrees(cartographic.latitude);
    text +=longitudeString+" "+latitudeString+" ";
    text1 +=proj4(wgs84,utm,[longitudeString, latitudeString])[0]+" "+proj4(wgs84,utm,[longitudeString, latitudeString])[1]+","
    
    };
   
    newfilter= String(text + String(text).split(' ')[0] + " " + String(text).split(' ')[1]).split(' ').join('%20');
    newfilter1= String(text1)+String(text1).split(',')[0];
 
    fetch(`http://119.75.24.66:8000/citydb-wfs/wfs?service=WFS&version=2.0.0&request=GetFeature&TYPENAMES=bldg:Building&FILTER=<Filter%20xmlns="http://www.opengis.net/fes/2.0"><Within><ValueReference>gml:boundedBy</ValueReference><Polygon%20xmlns="http://www.opengis.net/gml"%20srsName="urn:ogc:def:crs:EPSG::4326"><exterior><LinearRing%20srsName="urn:ogc:def:crs:EPSG::4326"><posList>`+newfilter+`</posList></LinearRing></exterior></Polygon></Within></Filter>&maxFeatures=10000&outputFormat=application/json`)
    .then((res)=> res.json())
    .then(output =>{
    var blds="";
    var obj=JSON.parse(JSON.stringify(output));
    const object1 =obj;
    
    
    
    blds = String(Object.keys(object1.CityObjects)).split(',');
    console.log(blds)
    
   
    
		function highlightBuildings(item){
            
			var layer = vcs.vcm.Framework.getInstance().getLayerByName("Buildings");
			var toHighlight = {};
			toHighlight[item] = Cesium.Color.RED;
			layer.highlight(toHighlight);
            return toHighlight;
          
            
            
		} 
   
    
    for (j=0; j<blds.length; j++){
    highlightBuildings(blds[j]);
    
    
    }
      
    

   
   

    
    })
    

if (String(newfilter1).length>0){

var span =document.getElementById('download1').children[0];
    span.setAttribute('href',`http://tcp.imagetrekk.com:8080/geoserver/tcp/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=tcpo:tcpo_building_14_oct&cql_filter=Within (the_geom, POLYGON((`+newfilter1+`)))&maxFeatures=10000&outputFormat=shape-zip`);
    span.setAttribute('type', "button"); 

} else {console.log('error')}
    


      

    
    
    
 
    
    
    
}
var activeShapePoints = [];
var activeShape;
var floatingPoint;
var handler = new Cesium.ScreenSpaceEventHandler(scene.canvas);
handler.setInputAction(function(event) {

   if (document.getElementById("polygonfilter").checked==true) {        

    // We use `viewer.scene.pickPosition` here instead of `viewer.camera.pickEllipsoid` so that
    // we get the correct point when mousing over terrain.
    var earthPosition = scene.pickPosition(event.position);
    // `earthPosition` will be undefined if our mouse is not over the globe.
    if (Cesium.defined(earthPosition)) {
        if (activeShapePoints.length === 0) {
            floatingPoint = createPoint(earthPosition);
            activeShapePoints.push(earthPosition);
            var dynamicPositions = new Cesium.CallbackProperty(function () {
                if (drawingMode === 'polygon') {
                    return new Cesium.PolygonHierarchy(activeShapePoints);
                
                }
                return activeShapePoints;
            }, false);
            activeShape = drawShape(dynamicPositions);
        }
       
        if (document.getElementById("polygonfilter").checked==true) {activeShapePoints.push(earthPosition);
        createPoint(earthPosition);}
    }
      
   }    
}, Cesium.ScreenSpaceEventType.LEFT_CLICK);

 
  
handler.setInputAction(function(event) {
  if (document.getElementById("polygonfilter").checked==true) {
    if (Cesium.defined(floatingPoint)) {
        
        
        var newPosition = scene.pickPosition(event.endPosition);
        if (Cesium.defined(newPosition)) {
            
            floatingPoint.position.setValue(newPosition);
            activeShapePoints.pop();
            activeShapePoints.push(newPosition);
        }
    }
  }
}, Cesium.ScreenSpaceEventType.MOUSE_MOVE);



function terminateShape() {
  if (document.getElementById("polygonfilter").checked==true) {
  
    activeShapePoints.pop();
    
    drawShape(activeShapePoints);
    map.getEntities().remove(floatingPoint);
    map.getEntities().remove(activeShape);
    floatingPoint = undefined;
    activeShape = undefined;
    activeShapePoints = [];
  }
   
}
handler.setInputAction(function(event) {
  if (document.getElementById("polygonfilter").checked==true) {
    terminateShape();
  }else{
  map.getEntities().removeAll();
    
 
     function clearHighlight(){
			var framework = vcs.vcm.Framework.getInstance();
			framework.getLayerByName("Buildings").clearHighlighting();
		};
                   
      
    clearHighlight();
    colormatarial=Cesium.Color.WHITE.withAlpha(0)
  }
}, Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);



}

function floodmode(){

  
  

var co = [77.273425871, 28.387350263, 0,
    77.326597000, 28.387350263, 0,
    77.326597000, 28.440072527, 0,
    77.273425871, 28.440072527, 0];


var water = map.getEntities().add({
  position: Cesium.Cartesian3.fromDegrees(77.306597000, 28.410072527, 0),
    name : 'Green circle at height with outline',
    ellipse : {
        semiMinorAxis : 5000.0,
        semiMajorAxis : 5000.0,
        height: 140,
        extrudedHeight:1,
        material : Cesium.Color.BLUE.withAlpha(0.4),
        outline : false // height must be set for outline to display
    }
});
  
  
var viewModel = {
    alpha: 0.15,
    height: 130,
    
};
Cesium.knockout.track(viewModel);  
  

var toolbar = document.getElementById('toolbar');
Cesium.knockout.applyBindings(viewModel, toolbar);

Cesium.knockout.getObservable(viewModel, 'alpha').subscribe(
    function(newValue) {
        var alpha = parseFloat(newValue);
        water.polygon.material = Cesium.Color.BLUE.withAlpha(alpha);
    }
);

Cesium.knockout.getObservable(viewModel, 'height').subscribe(
    function(newValue) {
        water.ellipse.extrudedHeight = newValue;
    }
);


}



function onMAPLoaded(){
var framework = vcs.vcm.Framework.getInstance();
map = framework.getMapByType('vcs.vcm.maps.Cesium');

scene = map.getScene();

layers = scene.imageryLayers;
  
  



setTimeout(floodmode,1000);
 

};

/** function for document ready */
$(document).ready(function(){
  document.getElementByClassName('tool-box').style.float = 'left';
    //window["vcs"]["vcm"].Gui.relocateContentToLeft();
    //window["vcs"]["vcm"].Gui.hideSearch();
});