var toolboxButton1 = {
  template: '<span class="layer-switch-btn" :class="{ \'sat-switch\': active, \'osm-switch\': !active }" @click="clickHandler" title="Umschalten auf Kartenansicht mit untexturierten Gebäuden"><span class="layer-switch-txt vcm-font-default" :class="{ active: active }">Karte</span></span>',
  data: function() {
    return {
      active: true,
    }
  },
  created: function() {
    vcs.vcm.Framework.getInstance().subscribe('LAYER_CHANGED', function(layer) {
      if(layer.name === 'buildings') {
        this.active = layer.isActive();
      }
    }.bind(this));
  },
  methods: {
    clickHandler: function() {
      this.toggleLayer();
    },
    toggleLayer: function() {
      var layer = vcs.vcm.Framework.getInstance().getLayerByName('buildings')
      layer.activate(!layer.isActive());
    }
  }
};
var toolboxButton2 = {
  template: '<span class="next-viewpoint-btn" @click="clickHandler" title="Zu nächstem Viewpoint springen"><i class="fa fa-2x fa-play"></i><span class="next-vp-txt vcm-font-default">{{currentVp}}</span></span>',
  data: function() {
    return {
      currentVp: null,
      vpIndex: -1,
    }
  },
  methods: {
    clickHandler: function() {
      var framework = this.getFramework();
      var vps = framework.getViewPoints();
      if (!vps.length) {
        return;
      }
      this.vpIndex += 1;
      if (this.vpIndex === vps.length) {
        this.vpIndex = 0;
      }
      var vp = vps[this.vpIndex];
      this.currentVp = vp.name || this.vpIndex;
      framework.getActiveMap().gotoViewPoint(vp);
    },
  }
}
vcs.vcm.Framework.getInstance().subscribe("UI_INITIALIZED", function() {
  vcs.ui.registerPlugin({
    name: 'LayerSwitcher',
    toolboxButton: [toolboxButton1, toolboxButton2]
  });
})




